﻿using System;

namespace Coscine.Database.ReturnObjects
{
    [Serializable]
    public class GitlabResourceTypeObject : ResourceTypeOptionObject
    {
        public Guid Id { get; set; }

        public int RepositoryNumber { get; set; }
        public string RepositoryUrl { get; set; }
        public string Token { get; set; }

        public GitlabResourceTypeObject(Guid id, int repositoryNumber, string repositoryUrl, string token)
        {
            Id = id;
            RepositoryNumber = repositoryNumber;
            RepositoryUrl = repositoryUrl;
            Token = token;
        }
    }
}
