﻿using Microsoft.EntityFrameworkCore;
using Coscine.Database.Settings;
using Coscine.Database.DataModel;
using Coscine.Configuration;


namespace Coscine.Database
{
    public partial class CoscineDB : Model
    {
        public static DatabaseSettingsConfiguration DatabaseSettingsConfiguration { get; set; }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            DatabaseSettingsConfiguration databaseSettingsConfiguration;
            if (DatabaseSettingsConfiguration == null)
            {
                IConfiguration _configuration = new ConsulConfiguration();
                databaseSettingsConfiguration = new DatabaseSettingsConfiguration(_configuration);
            } 
            else
            {
                databaseSettingsConfiguration = DatabaseSettingsConfiguration;
            }
            optionsBuilder.UseSqlServer(databaseSettingsConfiguration.ConnectionStrings());
        }
    }
}
