﻿using Coscine.Database.DataModel;
using System;
using System.Collections.Generic;
using System.Linq.Expressions;

namespace Coscine.Database.Models
{
    public class RdsS3ResourceTypeModel : DatabaseModel<RdsS3resourceType>
    {
        public override Expression<Func<RdsS3resourceType, Guid>> GetIdFromObject()
        {
            return (rdsResourceType) => rdsResourceType.Id;
        }

        public override Microsoft.EntityFrameworkCore.DbSet<RdsS3resourceType> GetITableFromDatabase(CoscineDB db)
        {
            return db.RdsS3resourceTypes;
        }

        public override void SetObjectId(RdsS3resourceType databaseObject, Guid id)
        {
            databaseObject.Id = id;
        }

        public Dictionary<string, string> GetResourceTypeOptions(Guid id)
        {
            var dictionary = new Dictionary<string, string>();
            var resourceType = GetById(id);
            dictionary.Add("accessKey", resourceType.AccessKey);
            dictionary.Add("secretKey", resourceType.SecretKey);
            dictionary.Add("accessKeyRead", resourceType.AccessKeyRead);
            dictionary.Add("secretKeyRead", resourceType.SecretKeyRead);
            dictionary.Add("accessKeyWrite", resourceType.AccessKeyWrite);
            dictionary.Add("secretKeyWrite", resourceType.SecretKeyWrite);
            dictionary.Add("bucketname", resourceType.BucketName);
            dictionary.Add("endpoint", resourceType.Endpoint);
            dictionary.Add("size", $"{resourceType.Size}");
            return dictionary;
        }
    }
}
