﻿using Coscine.Database.DataModel;
using Microsoft.EntityFrameworkCore;
using Coscine.Database.Util;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Coscine.Database.Models
{
    public class KpiModel : DatabaseModel<Kpi>
    {
        public override System.Linq.Expressions.Expression<Func<Kpi, Guid>> GetIdFromObject()
        {
            return (KpiObject) => KpiObject.Id;
        }

        public override DbSet<Kpi> GetITableFromDatabase(CoscineDB db)
        {
            return db.Kpis;
        }

        public override void SetObjectId(Kpi databaseObject, Guid id)
        {
            databaseObject.Id = id;
        }

        public int MarkAsSent(Kpi databaseObject)
        {
            databaseObject.SentSuccessfully = true;
            return Update(databaseObject);
        }
    }
}
