﻿using Coscine.WaterbutlerHelper.Services;
using Coscine.ApiCommons;
using Microsoft.Extensions.DependencyInjection;
using System;

namespace Coscine.Api.Tree
{
    /// <summary>
    /// standard startup class
    /// </summary>
    public class Startup : AbstractStartup
    {
        /// <summary>
        /// standard startup constructor
        /// </summary>
        public Startup()
        {

        }
        /// <summary>
        /// Configures custom service extension
        /// </summary>
        /// <param name="services">Services</param>
        public override void ConfigureServicesExtension(IServiceCollection services)
        {
            base.ConfigureServicesExtension(services);

            services.AddHttpClient<IDataSourceService, DataSourceService>(client =>
            {
                //TODO: Discuss Timeout value
                client.Timeout = TimeSpan.FromMinutes(30);
            });
        }
    }
}
